// Topic controller.
(function($, UTILS) {
    var self = undefined;

	$.widget('adsk.topiccontroller', {

		options: {
            targetId: 'topic',
            topicPathPrefix: './files',
            wrappedTopicPathPrefix: './wrapped-files',
            topicHTML: '',
            toc: undefined,
            favoritesController: undefined,
            searchOptions: undefined
		},

		/* Private members. */

		_view: undefined,
		_tocLoading: undefined,

        _defaultTopicData: undefined,
        _currentTopicData: undefined,
        _parentTopicData: undefined,

        _siblingTopicData: {
            prn: undefined, // previous
            nxn: undefined // next
        },

		_create: function() {
            console.log('topiccontroller: _create');

            this._tocLoading = $.Deferred();

            self = this;

            // Some initialization staff.
            $('#' + this.options.targetId).topicview({
                create: $.proxy(this._viewCreateHandler, this)
            });
		},

		_init: function() {
            this._trigger('ready');
        },

		_viewCreateHandler: function(event, ui) {
		    console.log('topiccontroller: _viewCreateHandler');

		    this._view = $(event.target).topicview('instance');
		},

		// Get JS wrapped file href by HTM file href.
        _getTopicHref: function(href) {
            console.log('topiccontroller: _getTopicHref, href = ' + href);

            // Turn ./files/topic.htm to ./wrapped-files/topic.htm.js
            // or something.htm to something.htm.js
            if (href.indexOf(this.options.topicPathPrefix) == 0) {
                // If starts with ./files
                return this.options.wrappedTopicPathPrefix + this._getFileFolderPathFromFullPath(href) + '.js';
            } else {
                return href + '.js';
            }
        },

		_getFileFolderPathFromFullPath: function(path) {
		    var prefix = this.options.topicPathPrefix,
		        pos = path.lastIndexOf(prefix),
		        filename = path.substring(pos + prefix.length);
		    return filename;
		},

		// Get topic data (title, href, id etc.) from TOC tree by ID, HREF or topic number.
        _fetchTopicData: function(data, bookName) {
            console.log('appcontroller: _fetchTopicData, data = ', data);

            var toc = this.options.toc,
                topic = undefined;

            if (toc !== undefined) {
                // Get topic data by topic ID.
                if (data.id !== undefined && data.id !== '') {
                    if (toc.tocDataIndexedById !== undefined) {
                        topic = toc.tocDataIndexedById[bookName][data.id];
                    }
                // Get topic data by href.
                } else if (data.href !== undefined && data.href !== '') {
                    // Crop url fragment.
                    var href = data.href;

                    if (data.href.lastIndexOf('#') != -1) {
                        href = data.href.substr(0, data.href.lastIndexOf('#'));
                    }

                    if (toc.tocDataIndexedByHref !== undefined &&
                        toc.tocDataIndexedByHref[bookName] !== undefined) {
                        topic = toc.tocDataIndexedByHref[bookName][href];
                    }
                // Get topic data by topic number.
                } else if (data.tn !== undefined && data.tn !== '') {
                    if (toc.tocDataIndexedByTopicNumber !== undefined) {
                        topic = toc.tocDataIndexedByTopicNumber[bookName][data.tn];
                    }
                }
            }

            if (topic === undefined) {
                topic = {
                    attr: {
                        href: data.href
                    }
                };
            } else {
                topic.attr.href = data.href; // Preserve url fragment.
            }

            return topic;
        },

        // Disable/enable navigation buttons and favorites.
        _setupTopicRelatedFeatures: function(topic, bookName) {
            console.log('topiccontroller: _setupTopicRelatedFeatures');

            var toc = this.options.toc,
                view = this._view;

            if (topic !== undefined && topic.attr.id !== undefined) {
                this._setupGoToParentFeature(toc, topic, view, bookName);
                this._setupGoToSiblingFeature('prn', toc, topic, view, bookName);
                this._setupGoToSiblingFeature('nxn', toc, topic, view, bookName);
                this._setupFavoritesFeature(topic, view);
                this._setupBreadcrumbsFeature(topic, bookName);
                this._setupTocFeature(topic);
            } else {
                this._disableTopicRelatedFeatures(view);
            }

        },

        _setupTocFeature: function(topicData) {
            console.log('topiccontroller: _setupTocFeature');

            this._trigger('setuptoc', {}, {
                href: topicData.attr.href
            });
        },

        _disableTopicRelatedFeatures: function(view) {
            console.log('topiccontroller: _disableTopicRelatedFeatures');

            this._initGoToPreviousButton(false);
            this._initGoToParentButton(false);
            this._initGoToNextButton(false);
            this._initFavoritesButton(false);

            this._siblingTopicData['prn'] = undefined;
            this._siblingTopicData['nxn'] = undefined;

            this._flagFavorites(false);
        },

        _setupGoToParentFeature: function(toc, topic, view, bookName) {
            console.log('topiccontroller: _setupGoToParentFeature');

            // Enable "Go to parent" button if parent topic available.
            var parentTopic = undefined;

            if (toc !== undefined) {
                var parentTopicNumber = topic.attr.pn;

                if (parentTopicNumber !== undefined) {
                    parentTopic = toc.tocDataIndexedByTopicNumber[bookName][parentTopicNumber]
                }

                var goToParentButtonEnabled = (parentTopic !== undefined) ? true: false;

                if (goToParentButtonEnabled) {
                    this._parentTopicData = parentTopic;
                } else {
                    this._parentTopicData = undefined;
                }

                this._initGoToParentButton(goToParentButtonEnabled);
            } else {
                this._initGoToParentButton(false);
            }
        },

        // attr = prn || nxn.
        _setupGoToSiblingFeature: function(attr, toc, topic, view, bookName) {
            console.log('topiccontroller: _setupGoToSiblingFeature');

            // Fetch target topic (following or previous).
            var targetTopic = undefined;

            if (toc !== undefined) {
                var topicNumber = topic.attr[attr];

                if (topicNumber !== undefined) {
                    targetTopic = toc.tocDataIndexedByTopicNumber[bookName][topicNumber];
                }
            }

            // Enable button if 'previous/next' topic is available.
            var enabled = (targetTopic) ? true : false;

            if (attr == 'prn') {
                this._initGoToPreviousButton(enabled);
            } else {
                this._initGoToNextButton(enabled);
            }

            this._siblingTopicData[attr] = targetTopic;
        },

        _setupFavoritesFeature: function(topic, view) {
            console.log('topiccontroller: _setupFavoritesFeature');
            // Indicate if opened topic page is in favorites.
            if (this.options.favoritesController !== undefined) {
                this._initFavoritesButton(true);

                var isTopicInFavorites = this.options.favoritesController.isTopicIdInFavorites(topic.attr.id);

                this._flagFavorites(isTopicInFavorites);
            }
        },

        _setupBreadcrumbsFeature: function(topic, bookName) {
            console.log('topiccontroller: _setupBreadcrumbsFeature');

            this._trigger('setupbreadcrumbs', {}, {
                breadcrumbs: this._getBreadcrumbs(topic, bookName)
            });
        },

        _getBreadcrumbs: function(topic, bookName) {
            console.log('topiccontroller: _getBreadcrumbs');


            var breadcrumbs = [],
                parents = this._getTopicParents(bookName, topic.attr.tn)
                self = this;

            $.each(parents, function(index, parent) {
                breadcrumbs.push(self._getParentTopicData(parent));
            });

            return breadcrumbs;

        },

        _getTopicParents: function(bookName, topicNumber) {
            var parentsArray = [],
                currentTopic = this._getTopicData(bookName, topicNumber);

            if (currentTopic) {
                this._fillTopicParentsArray(bookName, currentTopic.attr.pn, parentsArray);
            }

            return parentsArray;
        },

        _getTopicData: function(bookName, topicNumber) {
            var toc = this.options.toc.tocDataIndexedByTopicNumber;

            return toc[bookName] ? toc[bookName][topicNumber] : undefined;
        },

        _fillTopicParentsArray: function(bookName, topicNumber, parentsArray) {
            var currentTopic = this._getTopicData(bookName, topicNumber);

            if (currentTopic) {
                var parentNumber = currentTopic.attr.pn;

                this._fillTopicParentsArray(bookName, parentNumber, parentsArray);

                parentsArray.push(currentTopic);
            }
        },

        _getParentTopicData: function(topic) {
            if (topic) {
                return {
                    title: topic.data,
                    href: topic.attr.href
                };
            } else {
                return undefined;
            }
        },

        _initGoToPreviousButton: function(enabled) {
            console.log('topiccontroller: _initGoToPreviousButton');

            this._trigger('initgotopreviousbutton', {}, {
                enabled: enabled
            });
        },

        _initGoToParentButton: function(enabled) {
            console.log('topiccontroller: _initGoToParentButton');

            this._trigger('initgotoparentbutton', {}, {
                enabled: enabled
            });
        },

        _initGoToNextButton: function(enabled) {
            console.log('topiccontroller: _initGoToNextButton');

            this._trigger('initgotonextbutton', {}, {
                enabled: enabled
            });
        },

        _initFavoritesButton: function(enabled) {
            console.log('topiccontroller: _initFavoritesButton');

            this._trigger('initfavoritesbutton', {}, {
                enabled: enabled
            });
        },

        _fireOpenTopicEvent: function(topic) {
            console.log('topiccontroller: _fireOpenTopicEvent');

            if (topic !== undefined) {
                this._currentTopicData = topic;

                this._trigger('opentopic', {}, {
                    href: topic.attr.href
                });
            }
        },

        _flagFavorites: function(added) {
            console.log('topiccontroller: _flagFavorites');

            this._trigger('flagfavorites', {}, {
                added: added
            });
        },

        // Get book name from path.
        // ./filesTEST1/topichead.htm => TEST1
        _getBookBase: function(path) {
            var pos = path.lastIndexOf('/'),
                base = path.substring(0, pos + 1);

            return base;
        },

        _getBookName: function(bookBase) {
            var files = '/files',
                startIndex = bookBase.lastIndexOf(files) + files.length,
                endIndex = bookBase.lastIndexOf('/');

            return bookBase.substring(startIndex, endIndex);
        },

		/* Public members. */

		setTocData: function(tocData) {
            console.log('topiccontroller: setTocData');

            if (tocData !== undefined) {
                this.options.toc = tocData;
                this._tocLoading.resolve();
            }
        },

        openTopic: function(data) {
            console.log('topiccontroller: openTopic, topic = ', data);

            var self = this;

            self._tocLoading.done(function() {
                // Show topic content.
                if (data) {
                    var href = data.href;

                    if (href.lastIndexOf('#') != -1) {
                        href = href.substr(0, data.href.lastIndexOf('#'));
                    }

                    // Get href to JS file.
                    var realHref = self._getTopicHref(href);

                    // Get book name to resolve inner links.
                    var bookBase = self._getBookBase(href);

                    // Get topic content either from local JS file or TODO: load with AJAX.

                    // yepnope.injectJs( scriptSource [, callback ] [, elemAttributes ] [, timeout ]);
                    // TODO: do not cache local js.
                    window.topic = '';

                    yepnope.injectJs(realHref, $.proxy(function() {
                        // Render topic content.
                        if ((window.topic !== '') && (window.topic !== self.options.topicHTML)) {
                            self.options.topicHTML = window.topic;

                            self._view.showTopicContent(self.options.topicHTML, bookBase);

                            self._view.scrollToFragment(data.href);

                            self._view.highlight(self.options.searchOptions);

                            // Get topic TOC data for specified book (parent topic, next topic etc.)
                            var bookName = self._getBookName(bookBase);

                            var topicData = self._currentTopicData = self._fetchTopicData(data, bookName);

                            // Initialize navigation buttons, favorites and else related to current topic.
                            self._setupTopicRelatedFeatures(topicData, bookName);
                        } else if (window.topic == self.options.topicHTML) {
                            console.log('Selected the same topic as current.');

                            self._view.scrollToFragment(data.href);
                        } else {
                            console.log('Something goes wrong :(');
                        }
                    }, self));

                }
            });
        },

        openPreviousTopic: function() {
            console.log('topiccontroller: openPreviousTopic');

            var prevTopic = this._siblingTopicData['prn'];

            this._fireOpenTopicEvent(prevTopic);
        },

        openParentTopic: function() {
            console.log('topiccontroller: openParentTopic');

            var parentTopic = this._parentTopicData;

            this._fireOpenTopicEvent(parentTopic);
        },

        openFollowingTopic: function() {
            console.log('topiccontroller: openFollowingTopic');

            var nextTopic = this._siblingTopicData['nxn'];

            this._fireOpenTopicEvent(nextTopic);
        },

        addOrRemoveTopicFromFavorites: function() {
            console.log('topiccontroller: addOrRemoveTopicFromFavorites');

            console.log('this._currentTopicData: ', this._currentTopicData);
            if (!this._currentTopicData) {
                return;
            }

            var attr = this._currentTopicData.attr;

            if (attr.id !== undefined) {
                console.log('topiccontroller: topicId = ', attr.id);
                var added = this.options.favoritesController.addOrRemoveFavoriteTopicId(attr.id);
                this._flagFavorites(added);
            }
        },

        highlightQuery: function(searchOptions) {
            console.log('topiccontroller: highlight');

            this.options.searchOptions = searchOptions;

            if (this._view) {
                this._view.highlight(searchOptions);
            }
        }
	});
})(jQuery);
// SIG // Begin signature block
// SIG // MIIbQQYJKoZIhvcNAQcCoIIbMjCCGy4CAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // CE1VU+u6Oo1vzEC6jd9eEd6VNtAZWLnFQp5Wq2KAQNOg
// SIG // ggoWMIIExzCCA6+gAwIBAgIQANMDPwr2vEKYUg3AWz9B
// SIG // yzANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xNzA2MjAwMDAw
// SIG // MDBaFw0xODA2MjAyMzU5NTlaMHgxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjENMAsGA1UECwwESVNSQzEXMBUGA1UEAwwOQXV0b2Rl
// SIG // c2ssIEluYy4wggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQDEm0ybXlDjakGjfPJQOz8JJyQPZ4frwCIk
// SIG // YuGOWfv+3NZI9Snuy2rQ00G3NuUtmIl0Y0MeypzK5A8s
// SIG // nDGR+bkcRvGn2OmMHS50aggKjsao+rCNMiC8btSwxojg
// SIG // ekzX093J9+/kauZtUESeku1KV2xsBhQ+KTc5TliNgJDJ
// SIG // kB8VW+i2bK0oVx4aMPjX8pivLnbZDYo48U5lQNJtKVBC
// SIG // tnfv0wz2QfRAvXARUxGAnn7xsdgQzYzV6wn+i6N/fMDl
// SIG // e+qWfumXUFSnueYpP85Yi3oNu5kFydgeu34/TTkF1+gD
// SIG // OXfEKLP3cInMUgL7EGTIzHlXaumXFVZobx75J77kq721
// SIG // AgMBAAGjggE+MIIBOjAJBgNVHRMEAjAAMA4GA1UdDwEB
// SIG // /wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzBhBgNV
// SIG // HSAEWjBYMFYGBmeBDAEEATBMMCMGCCsGAQUFBwIBFhdo
// SIG // dHRwczovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcC
// SIG // AjAZDBdodHRwczovL2Quc3ltY2IuY29tL3JwYTAfBgNV
// SIG // HSMEGDAWgBTUwAYiSes5S92T4lyhuEd2CXIDWDArBgNV
// SIG // HR8EJDAiMCCgHqAchhpodHRwOi8vcmIuc3ltY2IuY29t
// SIG // L3JiLmNybDBXBggrBgEFBQcBAQRLMEkwHwYIKwYBBQUH
// SIG // MAGGE2h0dHA6Ly9yYi5zeW1jZC5jb20wJgYIKwYBBQUH
// SIG // MAKGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3J0MA0G
// SIG // CSqGSIb3DQEBCwUAA4IBAQApMpNskUmvqk2ygWaCDz+3
// SIG // PTZOZl8Q1FKIoGnv2+iq6wblFUCZt+KgKKyoZoHX6GMd
// SIG // Z/YKeTi5PO4QpKQBgm82kOtKVOdUnRXhUderqaAGrX8W
// SIG // qmXjggda1kRud5e+mdcql+RV1A+RVjjVmSATbeXCC0H5
// SIG // mfvO4o5lnBOfkOQeqKxRjWdEhklOszd+1pQVFX761VyA
// SIG // GfXgr0Jtm9dptQBU1TPybl3+ypIV00IldfMGj1VOKZtd
// SIG // ZrgMiXrdaIWOqRhSEyDdQWvqGzTZm7x5elhF3vcGkRZb
// SIG // 1XqtS7OgDJ7wW0z28NMLA9yfFsPFfOQfMBEEgoCc01P9
// SIG // MBPyiz1XO28kMIIFRzCCBC+gAwIBAgIQfBs1NUrn23Tn
// SIG // QV8RacprqDANBgkqhkiG9w0BAQsFADCBvTELMAkGA1UE
// SIG // BhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8w
// SIG // HQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTow
// SIG // OAYDVQQLEzEoYykgMjAwOCBWZXJpU2lnbiwgSW5jLiAt
// SIG // IEZvciBhdXRob3JpemVkIHVzZSBvbmx5MTgwNgYDVQQD
// SIG // Ey9WZXJpU2lnbiBVbml2ZXJzYWwgUm9vdCBDZXJ0aWZp
// SIG // Y2F0aW9uIEF1dGhvcml0eTAeFw0xNDA3MjIwMDAwMDBa
// SIG // Fw0yNDA3MjEyMzU5NTlaMIGEMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAd
// SIG // BgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsxNTAz
// SIG // BgNVBAMTLFN5bWFudGVjIENsYXNzIDMgU0hBMjU2IENv
// SIG // ZGUgU2lnbmluZyBDQSAtIEcyMIIBIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAQ8AMIIBCgKCAQEA15VD1NzfZ645+1KktiYx
// SIG // BHDpt45bKro3aTWVj7vAMOeG2HO73+vRdj+KVo7rLUvw
// SIG // VxhOsY2lM9MLdSPVankn3aPT9w6HZbXerRzx9TW0IlGv
// SIG // IqHBXUuQf8BZTqudeakC1x5JsTtNh/7CeKu/71KunK8I
// SIG // 2TnlmlE+aV8wEE5xY2xY4fAgMxsPdL5byxLh24zEgJRy
// SIG // u/ZFmp7BJQv7oxye2KYJcHHswEdMj33D3hnOPu4Eco4X
// SIG // 0//wsgUyGUzTsByf/qV4IEJwQbAmjG8AyDoAEUF6QbCn
// SIG // ipEEoJl49He082Aq5mxQBLcUYP8NUfSoi4T+IdpcXn31
// SIG // KXlPsER0b21y/wIDAQABo4IBeDCCAXQwLgYIKwYBBQUH
// SIG // AQEEIjAgMB4GCCsGAQUFBzABhhJodHRwOi8vcy5zeW1j
// SIG // ZC5jb20wEgYDVR0TAQH/BAgwBgEB/wIBADBmBgNVHSAE
// SIG // XzBdMFsGC2CGSAGG+EUBBxcDMEwwIwYIKwYBBQUHAgEW
// SIG // F2h0dHBzOi8vZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUF
// SIG // BwICMBkaF2h0dHBzOi8vZC5zeW1jYi5jb20vcnBhMDYG
// SIG // A1UdHwQvMC0wK6ApoCeGJWh0dHA6Ly9zLnN5bWNiLmNv
// SIG // bS91bml2ZXJzYWwtcm9vdC5jcmwwEwYDVR0lBAwwCgYI
// SIG // KwYBBQUHAwMwDgYDVR0PAQH/BAQDAgEGMCkGA1UdEQQi
// SIG // MCCkHjAcMRowGAYDVQQDExFTeW1hbnRlY1BLSS0xLTcy
// SIG // NDAdBgNVHQ4EFgQU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // HwYDVR0jBBgwFoAUtnf6aUhHn1MS1cLqBzJ2B9GXBxkw
// SIG // DQYJKoZIhvcNAQELBQADggEBAH/ryqfqi3ZC6z6OIFQw
// SIG // 47e53PpIPhbHD0WVEM0nhqNm8wLtcfiqwlWXkXCD+VJ+
// SIG // Umk8yfHglEaAGLuh1KRWpvMdAJHVhvNIh+DLxDRoIF60
// SIG // y/kF7ZyvcFMnueg+flGgaXGL3FHtgDolMp9Er25DKNMh
// SIG // dbuX2IuLjP6pBEYEhfcVnEsRjcQsF/7Vbn+a4laS8Zaz
// SIG // rS359N/aiZnOsjhEwPdHe8olufoqaDObUHLeqJ/UzSwL
// SIG // NL2LMHhA4I2OJxuQbxq+CBWBXesv4lHnUR7JeCnnHmW/
// SIG // OO8BSgEJJA4WxBR5wUE3NNA9kVKUneFo7wjw4mmcZ26Q
// SIG // CxqTcdQmAsPAWiMxghCDMIIQfwIBATCBmTCBhDELMAkG
// SIG // A1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBv
// SIG // cmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBO
// SIG // ZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAz
// SIG // IFNIQTI1NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMgIQANMD
// SIG // Pwr2vEKYUg3AWz9ByzANBglghkgBZQMEAgEFAKB8MBAG
// SIG // CisGAQQBgjcCAQwxAjAAMBkGCSqGSIb3DQEJAzEMBgor
// SIG // BgEEAYI3AgEEMBwGCisGAQQBgjcCAQsxDjAMBgorBgEE
// SIG // AYI3AgEVMC8GCSqGSIb3DQEJBDEiBCBLGwiEoCj1Zr2t
// SIG // 0T5RIW6Yw0uqh4wh28/v41wt1qyD1zANBgkqhkiG9w0B
// SIG // AQEFAASCAQBwHD6XthBZ9Sh5Xftr8lroOc4b0PFXGXBs
// SIG // Z0YZFwl+ENSVDccJbpsn/8en75hz0+dHNnNQ72vvSPW+
// SIG // J2hLgux2cIRD3fUZNkkeu1wCJgxlNrj6Kc9z4O8LYULe
// SIG // t1dzIjDZ0GLoGYypeOM2vmiW6Y7RSXqV3ZvOZhHbRiyN
// SIG // cdWig48qGKjgaUPqJXyE4VW3tIFAaLHtl3tDETfvikQQ
// SIG // bzlv2rv53TrVgf7ePelXF7vFehzSBhwAEkY8HdsBUO/I
// SIG // GDEkRwM566X+TkS06Q3b0SMNWS3tEpE01D6NUTXahQfW
// SIG // QNF2xNMyChd7/Wq1+F+ro4/q0cx96JTk4Lm4eLSDMS8u
// SIG // oYIOPDCCDjgGCisGAQQBgjcDAwExgg4oMIIOJAYJKoZI
// SIG // hvcNAQcCoIIOFTCCDhECAQMxDTALBglghkgBZQMEAgEw
// SIG // ggEOBgsqhkiG9w0BCRABBKCB/gSB+zCB+AIBAQYLYIZI
// SIG // AYb4RQEHFwMwMTANBglghkgBZQMEAgEFAAQgkrLInFWB
// SIG // 5V/X6iWhVdl2JG7GSr+IZ72QX1ATo5mFYKkCFCsrd3/7
// SIG // s2rTcHWQIfn0dfCevViBGA8yMDE4MDExNjAzMDMzMFow
// SIG // AwIBHqCBhqSBgzCBgDELMAkGA1UEBhMCVVMxHTAbBgNV
// SIG // BAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQL
// SIG // ExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTEwLwYDVQQD
// SIG // EyhTeW1hbnRlYyBTSEEyNTYgVGltZVN0YW1waW5nIFNp
// SIG // Z25lciAtIEcyoIIKizCCBTgwggQgoAMCAQICEHsFsdRJ
// SIG // aFFE98mJ0pwZnRIwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTYwMTEyMDAw
// SIG // MDAwWhcNMzEwMTExMjM1OTU5WjB3MQswCQYDVQQGEwJV
// SIG // UzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24x
// SIG // HzAdBgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsx
// SIG // KDAmBgNVBAMTH1N5bWFudGVjIFNIQTI1NiBUaW1lU3Rh
// SIG // bXBpbmcgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQC7WZ1ZVU+djHJdGoGi61XzsAGtPHGsMo8F
// SIG // a4aaJwAyl2pNyWQUSym7wtkpuS7sY7Phzz8LVpD4Yht+
// SIG // 66YH4t5/Xm1AONSRBudBfHkcy8utG7/YlZHz8O5s+K2W
// SIG // OS5/wSe4eDnFhKXt7a+Hjs6Nx23q0pi1Oh8eOZ3D9Jqo
// SIG // 9IThxNF8ccYGKbQ/5IMNJsN7CD5N+Qq3M0n/yjvU9bKb
// SIG // S+GImRr1wOkzFNbfx4Dbke7+vJJXcnf0zajM/gn1kze+
// SIG // lYhqxdz0sUvUzugJkV+1hHk1inisGTKPI8EyQRtZDqk+
// SIG // scz51ivvt9jk1R1tETqS9pPJnONI7rtTDtQ2l4Z4xaE3
// SIG // AgMBAAGjggF3MIIBczAOBgNVHQ8BAf8EBAMCAQYwEgYD
// SIG // VR0TAQH/BAgwBgEB/wIBADBmBgNVHSAEXzBdMFsGC2CG
// SIG // SAGG+EUBBxcDMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8v
// SIG // ZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkaF2h0
// SIG // dHBzOi8vZC5zeW1jYi5jb20vcnBhMC4GCCsGAQUFBwEB
// SIG // BCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Muc3ltY2Qu
// SIG // Y29tMDYGA1UdHwQvMC0wK6ApoCeGJWh0dHA6Ly9zLnN5
// SIG // bWNiLmNvbS91bml2ZXJzYWwtcm9vdC5jcmwwEwYDVR0l
// SIG // BAwwCgYIKwYBBQUHAwgwKAYDVR0RBCEwH6QdMBsxGTAX
// SIG // BgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTMwHQYDVR0OBBYE
// SIG // FK9j1sqjToVy4Ke8QfMpojh/gHViMB8GA1UdIwQYMBaA
// SIG // FLZ3+mlIR59TEtXC6gcydgfRlwcZMA0GCSqGSIb3DQEB
// SIG // CwUAA4IBAQB16rAt1TQZXDJF/g7h1E+meMFv1+rd3E/z
// SIG // ociBiPenjxXmQCmt5l30otlWZIRxMCrdHmEXZiBWBpgZ
// SIG // jV1x8viXvAn9HJFHyeLojQP7zJAv1gpsTjPs1rSTyEyQ
// SIG // Y0g5QCHE3dZuiZg8tZiX6KkGtwnJj1NXQZAv4R5NTtzK
// SIG // EHhsQm7wtsX4YVxS9U72a433Snq+8839A9fZ9gOoD+NT
// SIG // 9wp17MZ1LqpmhQSZt/gGV+HGDvbor9rsmxgfqrnjOgC/
// SIG // zoqUywHbnsc4uw9Sq9HjlANgCk2g/idtFDL8P5dA4b+Z
// SIG // idvkORS92uTTw+orWrOVWFUEfcea7CMDjYUq0v+uqWGB
// SIG // MIIFSzCCBDOgAwIBAgIQVFjyqtdB1kS8hKl7oJZS5jAN
// SIG // BgkqhkiG9w0BAQsFADB3MQswCQYDVQQGEwJVUzEdMBsG
// SIG // A1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAdBgNV
// SIG // BAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsxKDAmBgNV
// SIG // BAMTH1N5bWFudGVjIFNIQTI1NiBUaW1lU3RhbXBpbmcg
// SIG // Q0EwHhcNMTcwMTAyMDAwMDAwWhcNMjgwNDAxMjM1OTU5
// SIG // WjCBgDELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFu
// SIG // dGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRl
// SIG // YyBUcnVzdCBOZXR3b3JrMTEwLwYDVQQDEyhTeW1hbnRl
// SIG // YyBTSEEyNTYgVGltZVN0YW1waW5nIFNpZ25lciAtIEcy
// SIG // MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
// SIG // mfP82AQJA4b511ymk8BCfOp8Y89dAOKO88CQ348p9Rjq
// SIG // lLeS5dewoHOB6OkKm0p8Af+dj6Q5pw7qRfQiDDpw7TlF
// SIG // i+TFG1zwRWhGJAVjdpsc/J5sKrFW5Yp/UnGu8jXVRiMG
// SIG // HM9ILR20zbjZdiOOHP8+v7sGXGkHpmUO+F6ufS7tTa41
// SIG // 78nXAEL9KJUOn11yQgm8w9pE0u3MR4Tk/MotrFi+rveu
// SIG // 2UQNCLfCd9YaQ3DRbgPeUpLEEAhx2boiVfIfvO2bnTvi
// SIG // Xh1Mg/+XD3sL51WDTtIN677X7K5uR7mf36XWUbwEVe3/
// SIG // J3BMye0qSxPhsblMD8kB7lVlX2kCeGbLPwIDAQABo4IB
// SIG // xzCCAcMwDAYDVR0TAQH/BAIwADBmBgNVHSAEXzBdMFsG
// SIG // C2CGSAGG+EUBBxcDMEwwIwYIKwYBBQUHAgEWF2h0dHBz
// SIG // Oi8vZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBka
// SIG // F2h0dHBzOi8vZC5zeW1jYi5jb20vcnBhMEAGA1UdHwQ5
// SIG // MDcwNaAzoDGGL2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
// SIG // ZWMuY29tL3NoYTI1Ni10c3MtY2EuY3JsMBYGA1UdJQEB
// SIG // /wQMMAoGCCsGAQUFBwMIMA4GA1UdDwEB/wQEAwIHgDB3
// SIG // BggrBgEFBQcBAQRrMGkwKgYIKwYBBQUHMAGGHmh0dHA6
// SIG // Ly90cy1vY3NwLndzLnN5bWFudGVjLmNvbTA7BggrBgEF
// SIG // BQcwAoYvaHR0cDovL3RzLWFpYS53cy5zeW1hbnRlYy5j
// SIG // b20vc2hhMjU2LXRzcy1jYS5jZXIwKAYDVR0RBCEwH6Qd
// SIG // MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTUwHQYD
// SIG // VR0OBBYEFAm1wf6WcpcpQ5rJ4AK6rvj9L7r2MB8GA1Ud
// SIG // IwQYMBaAFK9j1sqjToVy4Ke8QfMpojh/gHViMA0GCSqG
// SIG // SIb3DQEBCwUAA4IBAQAXswqI6VxaXiBrOwoVsmzFqYoy
// SIG // h9Ox9BxTroW+P5v/17y3lIW0x1J+lOi97WGy1KeZ5MPJ
// SIG // k8E1PQvoaApdVpi9sSI70UR617/wbVEyitUj3zgBN/bi
// SIG // Uyt6KxGPt01sejMDG3xrCZQXu+TbWNQhE2Xn7NElyix1
// SIG // mpx//Mm7KmirxH20z6PJbKfZxACciQp3kfRNovsxO4Zu
// SIG // 9uYfUAOGm7/LQqvmdptyWhEBisbvpW+V592uuuYiZfAY
// SIG // WRsRyc2At9iXRx9CCPiscR+wRlOz1LLVo6tQdUgSF4Kt
// SIG // z+BBTzJ+zZUcv5GKCD2kp2cClt8kTKXQQcCCYKOKFzJL
// SIG // 07zPpLSMMYICWjCCAlYCAQEwgYswdzELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MSgwJgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGltZVN0
// SIG // YW1waW5nIENBAhBUWPKq10HWRLyEqXugllLmMAsGCWCG
// SIG // SAFlAwQCAaCBpDAaBgkqhkiG9w0BCQMxDQYLKoZIhvcN
// SIG // AQkQAQQwHAYJKoZIhvcNAQkFMQ8XDTE4MDExNjAzMDMz
// SIG // MFowLwYJKoZIhvcNAQkEMSIEIHbyh8XvwaWC5IUDtFA6
// SIG // scwuE6nkY+8ngyssR+Avzy1NMDcGCyqGSIb3DQEJEAIv
// SIG // MSgwJjAkMCIEIM96wXrQR+zV/cNoIgMbEtTvB4tvK0xe
// SIG // a6Qfj/LPS61nMAsGCSqGSIb3DQEBAQSCAQAqXyiZirM7
// SIG // MSLaSxgRPr1hzu1zwlgX8FZM21EN4VAf290M/faZiQZ0
// SIG // 27hQBktcQKDqGtbUSeqEiXq/8/Vuuc5NA0DZaFpkHq6t
// SIG // eV9JhO5I0M35GnaVKGJfYanA2oJabDPbyopNBqi+aJFt
// SIG // Oo53ex6NsoB8GDA85xE77V6bBKhz+rb+PkUOM8TzJuzB
// SIG // YPUlg7r1WgAkRIpKVgvZACDQCow3wB9SdduOe7MZuRhN
// SIG // 1cB9q+sXDg9VHd90o2eqrcNQ2Yqw2PcXB6HAha09C27/
// SIG // QGeXRREsp9DvNQSH54YlSJOMqut22Pf1t49Ut2hIiio0
// SIG // 8fXPNj1oA/LgFsDKXz7hhW8e
// SIG // End signature block
